﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using Microsoft.ProgramSynthesis.NLToCode;
using Microsoft.ProgramSynthesis.NLToM.Tests;
using Microsoft.ProgramSynthesis.Wrangling.Schema.TableOutput;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace NLToCode.Evaluation {
    public class Bing21Utils {

        public static string GetCorrectTableName(string predCode) {
            string pattern = @"\(([^,]+),";
            var matchPred = Regex.Match(predCode, pattern);
            if (matchPred.Groups.Count > 1) {
                return matchPred.Groups[1].Value;
            }
            pattern = @"[#]?["" \w]+{";
            matchPred = Regex.Match(predCode, pattern);
            if (matchPred.Groups.Count > 0) {
                return matchPred.Groups[0].Value.Trim('{');
            }
            return predCode;
        }

        public async static Task<int> DumpQueries(Bing21Data bing21Data, List<string> mQueries, int id, string outputPath) {
            var data = bing21Data.Data.Take(1000).ToList();
            ITable<object> tableData = new Table<object>(bing21Data.ColumnNames, data);
            //ITable<object> outputTable = new Table<object>(new List<string>(), data);
            bool foundLoadingQ = false;
            string tableName = "Source";
            var queries = new List<string>();
            MExecutionEngine mExecutionEngine = new();
            foreach (var q in mQueries) {
                if (q.Contains("let") || !await mExecutionEngine.IsValidProgramAsync(q) || q.Split('=')[0].Trim() == "Source" || q.Contains($"{tableName}{{")) {
                    if (q.Contains($"{tableName}")) {
                        queries.Add(q.Trim());
                        foundLoadingQ = true;
                        tableName = q.Split('=')[0].Trim();
                    }
                    continue;
                }

            }
            if (foundLoadingQ) {
                var q = string.Join(",\n", queries);
                //Benchmark ben = new Benchmark();
                //ben.Id = id++;
                //ben.Answer = q;
                //ben.Dataset = Utils.ConvertToTableData(tableData);
                //Utils.WriteBenchmark("Bing21",ben, outputPath);

                File.AppendAllText(@"C:\Users\t-anikhatry\Experiments\DIText\text.txt", q + "\n\n");

            }
            return id;
        }

        public async static Task<int> ConvertBing21DataToSingleSteps(Bing21Data bing21Data, List<string> mQueries, int id, string outputPath) {
            string tableName = "Source";
            string outputTableName = "";
            var data = bing21Data.Data.Take(1000).ToList();
            ITable<object> tableData = new Table<object>(bing21Data.ColumnNames, data);
            Dictionary<string, ITable<object>> outputTableDict = new Dictionary<string, ITable<object>> {
                { tableName, tableData }
            };
            MExecutionEngine mExecutionEngine = new();
            foreach (var q in mQueries) {
                if (q.Contains("let") || !await mExecutionEngine.IsValidProgramAsync(q) || q.Split('=')[0].Trim() == "Source") {
                    if (q.Contains("Source")) {

                    }
                    continue;
                }
                else {
                    string processedMQuery = q.Substring(q.IndexOf('=') + 1);
                    outputTableName = q.Split('=')[0].Trim(new char[] { ',', '\"', '#', ' ' });
                    tableName = GetCorrectTableName(q).Trim(new char[] { ',', '\"', '#', ' ' });
                    if (!outputTableDict.ContainsKey(tableName)) {
                        continue;
                    }
                    var outputTable = await mExecutionEngine.ExecuteProgramOnTableAsync(processedMQuery, outputTableDict[tableName], tableName);
                    if (outputTable == null) {
                        continue;
                    }
                    if (!Microsoft.ProgramSynthesis.NLToCode.Session.TableEquivalence.Equals(outputTable, outputTableDict[tableName])) {
                        outputTableDict.Add(outputTableName, outputTable);
                        var benchmark = CreateBenchmark(id++, q, tableName, tableData);
                        Utils.WriteBenchmark("Bing21", benchmark, outputPath);
                    }

                }

            }
            return id;
        }

        public async static Task<bool> ConvertBing21DataToMultiStep(Bing21Data bing21Data, List<string> mQueries) {
            string tableName = "Source";
            string outputTableName = "";
            bool executableQueryFound = false;
            var data = bing21Data.Data.Take(1000).ToList();
            ITable<object> tableData = new Table<object>(bing21Data.ColumnNames, data);
            Dictionary<string, ITable<object>> outputTableDict = new Dictionary<string, ITable<object>> {
                { tableName, tableData }
            };
            MExecutionEngine mExecutionEngine = new();
            foreach (var q in mQueries) {
                if (q.Contains("let") || !await mExecutionEngine.IsValidProgramAsync(q) || q.Split('=')[0].Trim() == "Source") {
                    if (q.Contains("Source")) {

                    }
                    continue;
                }
                else {
                    string processedMQuery = q.Substring(q.IndexOf('=') + 1);
                    outputTableName = q.Split('=')[0].Trim(new char[] { ',', '\"', '#', ' ' });
                    tableName = GetCorrectTableName(q).Trim(new char[] { ',', '\"', '#', ' ' });
                    if (!outputTableDict.ContainsKey(tableName)) {
                        continue;
                    }
                    var outputTable = await mExecutionEngine.ExecuteProgramOnTableAsync(processedMQuery, outputTableDict[tableName], tableName);
                    if (outputTable == null) {
                        continue;
                    }
                    if (!Microsoft.ProgramSynthesis.NLToCode.Session.TableEquivalence.Equals(outputTable, outputTableDict[tableName])) {
                        outputTableDict.Add(outputTableName, outputTable);
                        executableQueryFound = true;
                    }

                }

            }
            
            if(executableQueryFound) {
                return true;
            }

            return false;
        }
        public static Benchmark CreateBenchmark(int id, string query, string inputTable, ITable<object> table) {
            Benchmark benchmark = new();
            benchmark.Id = id;
            benchmark.Question = "";
            benchmark.Answer = query;
            benchmark.Source = "Bing21";
            benchmark.InputTable = inputTable;
            benchmark.Dataset = Utils.ConvertToTableData(table);
            benchmark.MatchColumns = "FALSE";
            return benchmark;
        }

        public class BingDataWrapper {
            public string Filename { get; set; }
            public Dictionary<string, Bing21Data> Tables { get; set; }
        }
        //Bing21 Data Loading
        public class Bing21Data {
            public string SheetName { get; set; }
            public string TableName { get; set; }
            public List<List<string>> Data { get; set; }
            public List<string> ColumnNames { get; set; }
        }
    }
}
